/*
 * Decompiled with CFR 0.152.
 */
package mhzd.net.autoclick.network;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class AnnotationScanner {
    private static final Logger log = LogManager.getLogger();

    public static Stream<Method> findMethods(ASMDataTable table, Class<? extends Annotation> ann) {
        return table.getAll(ann.getTypeName()).stream().map(data -> {
            try {
                Class<?> clazz = Class.forName(data.getClassName());
                String fullDesc = data.getObjectName();
                int idx = fullDesc.indexOf(40);
                String methodName = fullDesc.substring(0, idx);
                String desc = fullDesc.substring(idx);
                Type[] rawArgs = Type.getArgumentTypes((String)desc);
                Class[] args = new Class[rawArgs.length];
                for (int i = 0; i < rawArgs.length; ++i) {
                    args[i] = AnnotationScanner.type2Class(rawArgs[i]);
                }
                return clazz.getDeclaredMethod(methodName, args);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                log.catching((Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull);
    }

    public static Stream<Method> findPublicStaticMethods(ASMDataTable table, Class<? extends Annotation> ann) {
        return AnnotationScanner.findMethods(table, ann).filter(e -> {
            int mod = e.getModifiers();
            return Modifier.isPublic(mod) && Modifier.isStatic(mod);
        });
    }

    public static Stream<Class<?>> findClass(ASMDataTable table, Class<? extends Annotation> ann) {
        return ((Stream)table.getAll(ann.getTypeName()).stream().parallel()).map(data -> {
            try {
                return Class.forName(data.getObjectName());
            }
            catch (ClassNotFoundException e) {
                log.catching((Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).map(e -> e);
    }

    private static Class<?> type2Class(Type type) throws ClassNotFoundException {
        switch (type.getSort()) {
            case 0: {
                return Void.TYPE;
            }
            case 1: {
                return Boolean.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
            case 9: {
                return Class.forName(type.toString().replace('/', '.'));
            }
            case 10: {
                return Class.forName(type.getClassName());
            }
        }
        throw new IllegalArgumentException(type.toString());
    }
}

